#pragma once

#include "stdafx.h"
#include "WinDef.h"
#include "PCAN-ISO-TP.h"

/// <summary>
/// Class that stores information on a received ISO-TP message.
/// </summary>
class MessageStatus {

public:
	MessageStatus(TPCANTPMsg canTpMsg, TPCANTPTimestamp canTpTimestamp, int listIndex);

public_method:
	CString UID();
	CString CanIdType();
	CString MsgType();
	CString FormatType();
	CString TargetType();
	CString SourceAddress();
	CString TargetAddress();
	CString RemoteAddress();
	CString LengthString();
	CString DataString();
	CString ResultString();
	CString TimeString();
	TPCANTPMsg CanTpMsg();
	TPCANTPTimestamp Timestamp();
	void update(TPCANTPMsg canTpMsg, TPCANTPTimestamp canTpTimestamp);
	bool isSameNetAddrInfo(TPCANTPMsg canTpMsg);
	void setShowingPeriod(bool value);
	int Position();
	int Count();

private_properties:
	/// <summary>
	/// The last ISO-TP message received.
	/// </summary>
	TPCANTPMsg m_msg;
	/// <summary>
	/// The timestamp of the last ISO-TP message received.
	/// </summary>
	TPCANTPTimestamp m_timeStamp;
	/// <summary>
	/// The timestamp of the before last ISO-TP message received.
	/// </summary>
	TPCANTPTimestamp m_timeStampOld;
	/// <summary>
	/// Index of the object in the message listView.
	/// </summary>
	int m_index;
	/// <summary>
	/// Number of similar ISO-TP message received 
	/// (i.e. messages having the same Network Address Information).
	/// </summary>
	int m_count;
	/// <summary>
	/// States if the timestamp should be displayed as a period.
	/// </summary>
	bool m_showPeriod;
	/// <summary>
	/// States if the object has been modified but not updated/displayed on the UI.
	/// </summary>
	bool m_wasChanged;
};